﻿var rules = {
    context: $(".v-callbacks-rules"),
    datatable: null,
    resultCodes: null,
    interviewers: null,
    initializeDataTable: function () {
        this.datatable = $(".h-rules-table", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getProjectAction("GetRules", "CallBacks"),
            columns: [
                { "Title": resources.Callback, "Name": "Callback", "Data": "CallbackLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.Result, "Data": "ResultDescription", "Type": "multiple", "Editable": { "AvailableValues": function () { return rules.getResultCodes(); }, "MaxItems": 1, "LabelField": "Name", "ValueField": "Id", "Required": true } },
                { "Title": resources.Frequency, "Data": "Count", "Type": "numeric", "Editable": true },
                { "Title": resources.Consecutive, "Name": "Consecutive", "Data": "ConsecutiveLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.Interviewer, "Data": "InterviewerDescription", "Type": "multiple", "Editable": { "AvailableValues": function () { return rules.getInterviewers(); }, "MaxItems": 1, "LabelField": "Name", "ValueField": "Id" } },
                { "Title": resources.Delay, "Data": "Delay", "Type": "numeric", "Editable": true },
                { "Title": resources.Unit, "Data": "UnitEnum", "Name": "Unit", "Type": "enum", "EnumType": "RulUnits", "Editable": { "Nullable": false } },
                { "Title": resources.PriorityAction, "Data": "PriorityTypeEnum", "Name": "PriorityType", "Type": "enum", "EnumType": "RulPriorityTypes", "Editable": { "Nullable": false } },
                { "Title": resources.Priority, "Data": "Priority", "Type": "numeric", "Editable": { "MinValue": 0, "MaxValue": 9 } },
                { "Title": resources.DialingMode, "Data": "DialingModeEnum", "Name": "DialingMode", "Type": "enum", "EnumType": "DialingModes", "Editable": { "Nullable": false } },
                { "Title": resources.Counter, "Name": "WaveInc", "Data": "WaveIncLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.SynchResult, "Data": "SynchResultEnum", "Name": "SynchResult", "Type": "enum", "EnumType": "SynchResults", "Visible": projectMenu.project.EnableCAPI, "HideInSelector": !projectMenu.project.EnableCAPI, "Editable": { "Nullable": false } },
                { "Title": resources.LiftStratumRestriction, "Name": "RestrictionOverride", "Data": "RestrictionOverrideLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.UploadToA4S, "Name": "UploadToA4S", "Data": "UploadToA4SLabel", "Type": "boolean", "Editable": true, "Visible": projectMenu.project.EnableA4S, "HideInSelector": !projectMenu.project.EnableA4S },
                { "Title": resources.PhoneCyclingBehavior, "Data": "PhoneCyclingBehaviorEnum", "Name": "PhoneCyclingBehavior", "Type": "enum", "EnumType": "PhoneCyclingBehaviorType", "Editable": { "Nullable": false } },
            ],
            localizableTexts: { "Search": resources.SearchRules },
            stateKey: "CallbackRules",
            allowRowSelection: "[CanBeDeleted]",
            multiEdit: true,
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            rowsUpdated: function (event, data) {

                data.rows.forEach(function (row, index) { row["ResultDescription"] = ""; });

                a4.callServerMethod(a4.getProjectAction("UpdateRules", "CallBacks"), { rules: data.rows }, function () { data.multiEditSaveCallback(); });
            },
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": "[CanBeDeleted]" }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": "[CanBeDeleted]" },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        rules.deleteRules([row.Id]);
                        break;
                    case "properties":
                        rules.editRules(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    rules.deleteRules(ids);
                }
            },
            toggleMultiEdit: function (evt, data) {
                if (rules.resultCodes == null) {
                    a4.callServerMethod(a4.getProjectAction("GetResultCodesForAutoComplete", "CallBacks"), {}, function (result) {
                        rules.resultCodes = result;
                    });
                }

                if (rules.interviewers == null) {
                    a4.callServerMethod(a4.getProjectAction("GetInterviewersForAutoComplete", "CallBacks"), { isCallback: true }, function (result) {
                        rules.interviewers = result;
                    });
                }
            }
        });
    },
    bindEvents: function () {
        rules.context.on("click", ".h-add-rules", function () {
            modalDialog.showWindow(a4.getProjectAction("EditRule", "CallBacks"), 650, 750, { afterClose: function () { rules.refreshContent(); } });
        });

        rules.context.on("click", ".h-exportRules", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getProjectAction("ExportRules", "CallBacks"), { columns: rules.datatable.a4datatable("getVisibleColumns").join() }, function (result) {
                a4.hideBusyBox();
                window.location = a4.getProjectAction("GetRulesFile", "CallBacks", { filePath: result, fileName: "Rule.xlsx" });
            });
        });

        rules.context.on("click", ".h-copyRules", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyRules", "CallBacks"), { sourceProjectId: sourceProjectId },
                function (result) {
                    rules.refreshContent();
                });
            }, resources.CopyCallbackRulesFrom, false, confirmCopyRulesResources);
        });

        rules.context.on("click", ".h-settings", function () {
            modalDialog.showWindow(a4.getProjectAction("RuleSettings", "CallBacks"), 350, 600, { afterClose: function () { rules.refreshContent(); } });
        });
    },
    deleteRules: function (ruleIds) {
        modalDialog.showConfirmDelete(confirmDeleteRulesResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteRules", "CallBacks"), { ruleIds: ruleIds },
                function (result) {
                    rules.refreshContent();
                });
        }, ruleIds.length);
    },
    editRules: function (ruleId) {
        modalDialog.showWindow(a4.getProjectAction("EditRule", "CallBacks", { ruleId: ruleId }), 650, 700, { afterClose: function () { rules.refreshContent(); } });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    getResultCodes: function () {
        return rules.resultCodes;
    },
    getInterviewers: function () {
        return rules.interviewers;
    }
}

$(document).ready(function () {
    if (rules.context.length > 0) {
        $(projectMenu).ready(function () {
            rules.initializeDataTable();
            rules.bindEvents();
        });
    }
});